##########################################################################
### Regression analysis of Grazer and microalgae densities ##############
##########################################################################
### (c) T.R.Vonnahme #####################################################
##########################################################################
##################################################################

###Journal: Biogeosciences: special issue: Freshwater ecosystems in changing permafrost landscapes
###Title of the paper: Controls on microalgal community structures in cryoconite holes upon high Arctic glaciers, Svalbard

###Authors and affiliations:#######################################
#########T.R. Vonnahme1,2,*  M. Devetter1,3  J. D. rsk1,4  M. aback1,5  J. Elster1,6
#########[1] Centre for Polar Ecology, Faculty of Science, University of South Bohemia, Cesk Budejovice, Czech Republic
#########[2] University of Konstanz, Constance, Germany
#########[3] Biology Centre of the Academy of Science of the Czech Republic, Institute of Soil Biology, Cesk Budejovice, Czech Republic
#########[4] Department of Ecology, Charles University, Prague, Czech Republic
#########[5] British Antarctic Survey, Cambridge, UK
#########[6] Institute of Botany, Academy of the Science of the Czech Republic, Trebon, Czech Republic
#########[*] {now at: Max Planck Institute for Marine Microbiology, Bremen, Germany} 
#########Correspondence to: T. R. Vonnahme (t.r.vonnahme@gmail.com) 

##################################################################
###################################################################
##################################################################

###########################################################################
### data import and subsetting (1st transformation: alg/10^6)##############
##########################################################################

setwd("E://")

env<-read.table("allspecies.txt", header=T)

### subset with used variables, with NAs##############
all<-data.frame(env$Chlorococcales, env$Zygnemales, env$coc_cyano, env$filament_cyano,
    env$Tardigrades, env$Bdelloids_total, env$Ciliates)
specA<-data.frame(all$env.Chlorococcales /1000000, all$env.Zygnemales/1000000,
       all$env.filament_cyano /1000000, all$env.coc_cyano /1000000,
       all$env.Tardigrades, all$env.Bdelloids_total, all$env.Ciliates)
       colnames(specA)<-c("Chl", "Zyg", "Nos", "Osc", "Tar", "Rot","Cil") 
       row.names(specA)<-all$env.ID


############################################################################
### Regression analysis between grazer and algae ###########################
### test: Pearsons correlation ############################################
### model validation: histogram for normal distribution ###################
### p threshold: 0.05 #####################################################
### p correction: false discovery rate #####################################
### transformation: algae/10^6, all species: log(x) or log(x+1)
############################################################################

hist((log(specA$Chl+1)))
hist((log(specA$Zyg+1)))
hist(log(specA$Nos))
hist(log(specA$Osc))
hist(log(specA$Tar))
hist(log(specA$Rot))
hist(log(specA$Cil))
pairs(specA)

cor.test(log(specA$Chl+1), log(specA$Tar+1))#p 0.157
cor.test(log(specA$Chl+1), log(specA$Rot+1))#p 0.01876 cor 0.2323 pcor=0.075
cor.test(log(specA$Chl+1), log(specA$Cil+1))#p 0.6615
cor.test(log(specA$Nos+1), log(specA$Tar+1))#p 0.6576
cor.test(log(specA$Nos+1), log(specA$Rot+1))#p 0.278
cor.test(log(specA$Nos+1), log(specA$Cil+1))#p 0.7432
cor.test(log(specA$Osc+1), log(specA$Tar+1))#p 0.6636
cor.test(log(specA$Osc+1), log(specA$Rot+1))#p 0.527
cor.test(log(specA$Osc+1), log(specA$Cil+1))#p 0.3615
cor.test(log(specA$Zyg+1), log(specA$Tar+1))#p 0.00142 cor 0.3118 pcor=0.0170
cor.test(log(specA$Zyg+1), log(specA$Rot+1))#p 0.00327 cor 0.2885 pcor=0.0196
cor.test(log(specA$Zyg+1), log(specA$Cil+1))#p 0.2015

p<-c(0.157, 0.01876, 0.6615, 0.6576, 0.278, 0.7432, 0.6636, 0.527, 
0.3615, 0.00142, 0.00327, 0.2015)

p.adjust(p, method="fdr", n=12)

#[1] 0.4710000 0.0750400 0.7963200 0.7963200 1.0000000 0.8107636 0.7963200
#[8] 0.7963200 0.7230000 0.0170400* 0.0196200* 0.4836000

###correlation table: n=102

################### Tardigrades Rotifers Ciliates
# Chlorococcales r 0.141 0.232 -0.044
################ p 0.471 0.075 0.796
# Nostocales ### r 0.044 -0.108 0.033
################ p 0.796 1.000 0.811
# Oscillatoriales r 0.044 0.063 0.091
################# p  0.796 0.796 0.723 
# Zygnemales##### r 0.3118 0.2885 0.128
################# p 0.0171 0.0196 0.484


